/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.api.config.CondenserOutput;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.integrations.rei.IngredientConverter;
import appeng.api.integrations.rei.IngredientConverters;
import appeng.api.util.AEColor;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.StackWithBounds;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.FacadeCreativeTab;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.core.localization.ItemModText;
import appeng.integration.abstraction.ItemListMod;
import appeng.integration.abstraction.REIFacade;
import appeng.integration.modules.jeirei.CompatLayerHelper;
import appeng.integration.modules.rei.AttunementCategory;
import appeng.integration.modules.rei.AttunementDisplay;
import appeng.integration.modules.rei.ChargerCategory;
import appeng.integration.modules.rei.ChargerDisplay;
import appeng.integration.modules.rei.CondenserCategory;
import appeng.integration.modules.rei.CondenserOutputDisplay;
import appeng.integration.modules.rei.FacadeRegistryGenerator;
import appeng.integration.modules.rei.FluidIngredientConverter;
import appeng.integration.modules.rei.GhostIngredientHandler;
import appeng.integration.modules.rei.InscriberRecipeCategory;
import appeng.integration.modules.rei.InscriberRecipeWrapper;
import appeng.integration.modules.rei.ItemIngredientConverter;
import appeng.integration.modules.rei.ReiItemListModAdapter;
import appeng.integration.modules.rei.ReiRuntimeAdapter;
import appeng.integration.modules.rei.TransformCategory;
import appeng.integration.modules.rei.TransformRecipeWrapper;
import appeng.integration.modules.rei.transfer.EncodePatternTransferHandler;
import appeng.integration.modules.rei.transfer.UseCraftingRecipeTransfer;
import appeng.items.parts.FacadeItem;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import com.google.common.collect.ImmutableList;
import dev.architectury.event.CompoundEventResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import net.minecraft.class_768;

public class ReiPlugin
implements REIClientPlugin {
    private List<Predicate<class_1799>> developerItems;
    private List<Predicate<class_1799>> coloredCables;

    public ReiPlugin() {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        IngredientConverters.register(new ItemIngredientConverter());
        IngredientConverters.register(new FluidIngredientConverter());
        ItemListMod.setAdapter(new ReiItemListModAdapter());
        REIFacade.setInstance(new ReiRuntimeAdapter());
    }

    public String getPluginProviderName() {
        return "AE2";
    }

    public void registerCategories(CategoryRegistry registry) {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        registry.add((DisplayCategory)new TransformCategory());
        registry.add((DisplayCategory)new CondenserCategory());
        registry.add((DisplayCategory)new InscriberRecipeCategory());
        registry.add((DisplayCategory)new AttunementCategory());
        registry.add((DisplayCategory)new ChargerCategory());
        this.registerWorkingStations(registry);
    }

    public void registerDisplays(DisplayRegistry registry) {
        if (AEConfig.instance().isEnableFacadeRecipesInJEI()) {
            registry.registerGlobalDisplayGenerator((DynamicDisplayGenerator)new FacadeRegistryGenerator());
        }
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        registry.registerRecipeFiller(InscriberRecipe.class, InscriberRecipe.TYPE, InscriberRecipeWrapper::new);
        registry.registerRecipeFiller(ChargerRecipe.class, ChargerRecipe.TYPE, ChargerDisplay::new);
        registry.registerRecipeFiller(TransformRecipe.class, TransformRecipe.TYPE, TransformRecipeWrapper::new);
        registry.add((Display)new CondenserOutputDisplay(CondenserOutput.MATTER_BALLS));
        registry.add((Display)new CondenserOutputDisplay(CondenserOutput.SINGULARITY));
        this.registerDescriptions(registry);
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        registry.register(new EncodePatternTransferHandler<PatternEncodingTermMenu>(PatternEncodingTermMenu.class));
        registry.register(new UseCraftingRecipeTransfer<CraftingTermMenu>(CraftingTermMenu.class));
    }

    public void registerScreens(ScreenRegistry registry) {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new GhostIngredientHandler());
        registry.registerFocusedStack((screen, mouse) -> {
            AEBaseScreen aeScreen;
            StackWithBounds stack;
            if (screen instanceof AEBaseScreen && (stack = (aeScreen = (AEBaseScreen)screen).getStackUnderMouse(mouse.x, mouse.y)) != null) {
                for (IngredientConverter<?> converter : IngredientConverters.getConverters()) {
                    EntryStack<?> entryStack = converter.getIngredientFromStack(stack.stack());
                    if (entryStack == null) continue;
                    return CompoundEventResult.interruptTrue(entryStack);
                }
            }
            return CompoundEventResult.pass();
        });
        registry.registerContainerClickArea(new Rectangle(82, 39, 26, 16), InscriberScreen.class, new CategoryIdentifier[]{InscriberRecipeCategory.ID});
    }

    public void registerEntries(EntryRegistry registry) {
        this.developerItems = ImmutableList.of(AEBlocks.DEBUG_CUBE_GEN::isSameAs, AEBlocks.DEBUG_CHUNK_LOADER::isSameAs, AEBlocks.DEBUG_ENERGY_GEN::isSameAs, AEBlocks.DEBUG_ITEM_GEN::isSameAs, AEBlocks.DEBUG_PHANTOM_NODE::isSameAs, AEItems.DEBUG_CARD::isSameAs, AEItems.DEBUG_ERASER::isSameAs, AEItems.DEBUG_METEORITE_PLACER::isSameAs, AEItems.DEBUG_REPLICATOR_CARD::isSameAs);
        ArrayList<Predicate<class_1799>> predicates = new ArrayList<Predicate<class_1799>>();
        for (AEColor color : AEColor.values()) {
            if (color == AEColor.TRANSPARENT) continue;
            predicates.add(stack -> stack.method_7909() == AEParts.COVERED_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.COVERED_DENSE_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.GLASS_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.SMART_CABLE.item(color));
            predicates.add(stack -> stack.method_7909() == AEParts.SMART_DENSE_CABLE.item(color));
        }
        this.coloredCables = ImmutableList.copyOf(predicates);
        registry.removeEntryIf(this::shouldEntryBeHidden);
        if (AEConfig.instance().isEnableFacadesInJEI()) {
            registry.addEntries((Collection)EntryIngredients.ofItemStacks(FacadeCreativeTab.getDisplayItems()));
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        if (AEConfig.instance().isEnableFacadesInJEI()) {
            FacadeItem facadeItem = AEItems.FACADE.method_8389();
            registry.group(AppEng.makeId("facades"), (class_2561)class_2561.method_43471((String)"itemGroup.ae2.facades"), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((class_1799)stack.castValue()).method_31574((class_1792)facadeItem));
        }
    }

    public void registerExclusionZones(ExclusionZones zones) {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        zones.register(AEBaseScreen.class, screen -> screen != null ? ReiPlugin.mapRects(screen.getExclusionZones()) : Collections.emptyList());
    }

    private static List<Rectangle> mapRects(List<class_768> exclusionZones) {
        return exclusionZones.stream().map(ez -> new Rectangle(ez.method_3321(), ez.method_3322(), ez.method_3319(), ez.method_3320())).collect(Collectors.toList());
    }

    private void registerWorkingStations(CategoryRegistry registry) {
        class_1799 condenser = AEBlocks.CONDENSER.stack();
        registry.addWorkstations(CondenserCategory.ID, new EntryStack[]{EntryStacks.of((class_1799)condenser)});
        class_1799 inscriber = AEBlocks.INSCRIBER.stack();
        registry.addWorkstations(InscriberRecipeCategory.ID, new EntryStack[]{EntryStacks.of((class_1799)inscriber)});
        registry.setPlusButtonArea(InscriberRecipeCategory.ID, ButtonArea.defaultArea());
        class_1799 craftingTerminal = AEParts.CRAFTING_TERMINAL.stack();
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1799)craftingTerminal)});
        class_1799 wirelessCraftingTerminal = AEItems.WIRELESS_CRAFTING_TERMINAL.stack();
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1799)wirelessCraftingTerminal)});
        registry.addWorkstations(ChargerDisplay.ID, new EntryStack[]{EntryStacks.of((class_1799)AEBlocks.CHARGER.stack())});
        registry.addWorkstations(ChargerDisplay.ID, new EntryStack[]{EntryStacks.of((class_1799)AEBlocks.CRANK.stack())});
    }

    private void registerDescriptions(DisplayRegistry registry) {
        EntryIngredient all = (EntryIngredient)EntryRegistry.getInstance().getEntryStacks().collect(EntryIngredient.collector());
        for (P2PTunnelAttunementInternal.Resultant resultant : P2PTunnelAttunementInternal.getApiTunnels()) {
            List<EntryIngredient> inputs = List.of(all.filter(stack -> {
                Object patt11258$temp = stack.getValue();
                if (!(patt11258$temp instanceof class_1799)) return false;
                class_1799 s = (class_1799)patt11258$temp;
                if (!resultant.stackPredicate().test(s)) return false;
                return true;
            }));
            if (inputs.isEmpty()) continue;
            registry.add((Display)new AttunementDisplay(inputs, List.of(EntryIngredient.of((EntryStack)EntryStacks.of((class_1935)resultant.tunnelType()))), new class_2561[]{ItemModText.P2P_API_ATTUNEMENT.text(), resultant.description()}));
        }
        for (Map.Entry entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
            class_1856 ingredient = class_1856.method_8106((class_6862)((class_6862)entry.getKey()));
            if (ingredient.method_8103()) continue;
            registry.add((Display)new AttunementDisplay(List.of(EntryIngredients.ofIngredient((class_1856)ingredient)), List.of(EntryIngredient.of((EntryStack)EntryStacks.of((class_1935)((class_1935)entry.getValue())))), new class_2561[]{ItemModText.P2P_TAG_ATTUNEMENT.text()}));
        }
        ReiPlugin.addDescription(registry, AEItems.CERTUS_QUARTZ_CRYSTAL, GuiText.CertusQuartzObtain.getTranslationKey());
        if (AEConfig.instance().isSpawnPressesInMeteoritesEnabled()) {
            ReiPlugin.addDescription(registry, AEItems.LOGIC_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(registry, AEItems.CALCULATION_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(registry, AEItems.ENGINEERING_PROCESSOR_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
            ReiPlugin.addDescription(registry, AEItems.SILICON_PRESS, GuiText.inWorldCraftingPresses.getTranslationKey());
        }
        ReiPlugin.addDescription(registry, AEBlocks.CRANK, ItemModText.CRANK_DESCRIPTION.getTranslationKey());
    }

    private static void addDescription(DisplayRegistry registry, ItemDefinition<?> itemDefinition, String ... message) {
        DefaultInformationDisplay info = DefaultInformationDisplay.createFromEntry((EntryStack)EntryStacks.of(itemDefinition), (class_2561)itemDefinition.method_8389().method_7848());
        info.lines((Collection)Arrays.stream(message).map(class_2561::method_43471).collect(Collectors.toList()));
        registry.add((Display)info);
    }

    private boolean shouldEntryBeHidden(EntryStack<?> entryStack) {
        if (entryStack.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        class_1799 stack = (class_1799)entryStack.castValue();
        if (AEItems.WRAPPED_GENERIC_STACK.isSameAs(stack) || AEItems.FACADE.isSameAs(stack) || AEBlocks.CABLE_BUS.isSameAs(stack) || AEBlocks.MATRIX_FRAME.isSameAs(stack) || AEBlocks.PAINT.isSameAs(stack)) {
            return true;
        }
        if (!AEConfig.instance().isDebugToolsEnabled()) {
            for (Predicate<class_1799> developerItem : this.developerItems) {
                if (!developerItem.test(stack)) continue;
                return true;
            }
        }
        if (AEConfig.instance().isDisableColoredCableRecipesInJEI()) {
            for (Predicate<class_1799> predicate : this.coloredCables) {
                if (!predicate.test(stack)) continue;
                return true;
            }
        }
        return false;
    }
}

